# the autosyncwizard apm tab

			group apmpage {
				title above center "APM Strategy";
				geometry 0, 0, 650, 378;
				lock top, bottom, left, right;
				
				textnumber patternpoints;
				textnumber totaltiepoints;
				textnumber offcol;
				textnumber offlin;
				textnumber deltacol;
				textnumber deltalin;
				textnumber endcol;
				textnumber endlin;
				textnumber blunderremovaliteration;

				label apmpageinfo {
					value "Specify the automatic point measurement (APM) algorithm settings.";
					geometry 5, 5, 600, 26;
					lock top, left, width, height;
				}

				popuplist inputlayer {
					title left center "Input Layer to Use:";
					geometry 15, 40, 275, 26;
					lock top, left, width, height;
					info "Select the layer from the input images to be used for automatic point matching";
					titleoffset 120 noalign;
					on input {
						SetInputLayerForAPM($inputlayer);
					}
				}

				popuplist referencelayer {
					title left center "Reference Layer to Use:";
					geometry 335, 40, 285, 26;
					lock top, left, width, height;
					info "Select the layer from the reference image to be used for automatic point matching";
					titleoffset 130 noalign;
					on input {
						SetReferenceLayerForAPM($referencelayer);
					}
				}

				radiobutton patternused {
					title left center "Find Points With:";
					info "all the on-line images or only the active images";
					geometry 15, 75, 390, 26;
					lock top, left, width, height;
					titleoffset 117 noalign;
					options { 
						"Default Distribution",
						"Defined Pattern"
					};
					titlelist {
						"Default Distribution",
						"Defined Pattern"
					};
					layout horizontal;
					on valuechanged {
						SetAPMPatternUsed($patternused);
						if ($patternused == "Default Distribution") {
							hide patternpoints;
							show totaltiepoints;
							disable offcol;
							disable offlin;
							disable deltacol;
							disable deltalin;
							disable endcol;
							disable endlin;
						}
						else {
							hide totaltiepoints;
							show patternpoints;
							enable offcol;
							enable offlin;
							enable deltacol;
							enable deltalin;
							enable endcol;
							enable endlin;
						}
					}
				}

				textnumber totaltiepoints {
					title left center "Intended Number of Points/Image:";
					info "Intended number of tie points per image";
					geometry 15, 110, 275, 26;
					titleoffset 200 noalign;
					lock left, top, width, height;
					min 9;
					max 500000;
					format "4.0";
					on valuechanged {
						SetAPMTotalPointCount($totaltiepoints);
					}
				}

				textnumber patternpoints {
					title left center "Intended Number of Points/Pattern:";
					info "Intended number of tie points per pattern location";
					geometry 15, 110, 275, 26;
					titleoffset 200 noalign;
					lock left, top, width, height;
					min 1;
					max 8;
					format "4.0";
					on valuechanged {
						SetAPMPatternPointCount($patternpoints);
					}
				}

				checkbox keepallpoints {
					title right center "Keep All Points";
					info "Use all tie points regardless of accuracy or distribution.";
					geometry 333, 110, 120, 26;
					titleoffset 102 noalign;
					lock top, left, width, height;
					on valuechanged {
						SetAPMKeepAllPoints($keepallpoints);
					}
				}

				textnumber offcol {
					title left center "Starting Column:";
					info "Starting column for tie point in first image";
					geometry 15, 145, 200, 26;
					titleoffset 120 noalign;
					lock left, top, width, height;
					min 0;
					max 800000;
					format "0";
					on valuechanged {
						SetAPMOffsetCol($offcol);
					}
				}

				textnumber offlin {
					title left center "Starting Line:";
					info "Starting line for tie point in first image";
					geometry 335, 145, 205, 26;
					titleoffset 130 noalign;
					lock left, top, width, height;
					min 0;
					max 800000;
					format "0";
					on valuechanged {
						SetAPMOffsetLine($offlin);
					}
				}

				textnumber deltacol {
					title left center "Column Increment:";
					info "Increment in columns for tie point in first image";
					geometry 15, 180, 200, 26;
					titleoffset 120 noalign;
					lock left, top, width, height;
					min 128;
					max 80000;
					format "0";
					on valuechanged {
						SetAPMDeltaCol($deltacol);
					}
				}

				textnumber deltalin {
					title left center "Line Increment:";
					info "Increment in line for tie point in first image";
					geometry 335, 180, 205, 26;
					titleoffset 130 noalign;
					lock left, top, width, height;
					min 128;
					max 80000;
					format "0";
					on valuechanged {
						SetAPMDeltaLine($deltalin);
					}
				}

				textnumber endcol {
					title left center "Ending Column:";
					info "Ending column for tie point in first image";
					geometry 15, 215, 200, 26;
					titleoffset 120 noalign;
					lock left, top, width, height;
					min 0;
					max 800000;
					format "0";
					on valuechanged {
						SetAPMEndCol($endcol);
					}
				}

				textnumber endlin {
					title left center "Ending Line:";
					info "Ending line for tie point in first image";
					geometry 335, 215, 205, 26;
					titleoffset 130 noalign;
					lock left, top, width, height;
					min 0;
					max 800000;
					format "0";
					on valuechanged {
						SetAPMEndLine($endlin);
					}
				}

				checkbox removeblunders {
					title right center "Automatically Remove Blunders";
					info "Automatically remove wrong APM tie points";
					geometry 15, 250, 205, 26;
					titleoffset 156 noalign;
					lock top, left, width, height;
					on valuechanged {
						SetAPMRemoveBlunders($removeblunders);
						if ($removeblunders)
							enable blunderremovaliteration;
						else
							disable blunderremovaliteration;
					}
				}
				
				textnumber blunderremovaliteration {
					title left center "Maximum Blunder Removal Iterations:";
					info "Maximum allowed iterations for automatic blunder removal";
					geometry 280, 250, 260, 26;
					titleoffset 185 noalign;
					lock left, top, width, height;
					min 1;
					max 20;
					format "0";
					on valuechanged {
						SetAPMRemoveBlunderIteration($blunderremovaliteration);
					}
				}
				
				button resetapmstrategytodefault {
					title "Reset to Defaults";
					geometry 200, 346, 130, 26;
					lock bottom, left, width, height;
					info "Reset all APM parameters to their default values";
					on mousedown {
						SetAPMParametersToDefaults();
						groupdisplay();
					}
				}

				button advancedapmstrategy {
					title "Advanced Settings...";
					geometry 330, 346, 130, 26;
					lock bottom, left, width, height;
					info "Set advanced options for the point matching strategy";
					on mousedown {
						display advancedapmstrategyframe;
					}
				}
				
				on groupdisplay {
					variable layernames;
					variable layernumbers;
					variable imagewidth;
					variable imageheight;
					
					set layernames = GetInputImageLayerNamesForAPM();
					set layernumbers = GetInputImageLayerNumbersForAPM();
					$inputlayer.setnameandtitlelist($layernumbers,$layernames);
					set inputlayer = GetInputLayerForAPM();
									
					set layernames = GetReferenceImageLayerNamesForAPM();
					set layernumbers = GetReferenceImageLayerNumbersForAPM();
					$referencelayer.setnameandtitlelist($layernumbers,$layernames);
					set referencelayer = GetReferenceLayerForAPM();
									
					set patternused = GetAPMPatternUsed();
					set totaltiepoints = GetAPMTotalPointCount();
					set patternpoints = GetAPMPatternPointCount();
					set keepallpoints = GetAPMKeepAllPoints();
					set offcol = GetAPMOffsetCol();
					set offlin = GetAPMOffsetLine();
					set deltacol = GetAPMDeltaCol();
					set deltalin = GetAPMDeltaLine();
					set endcol = GetAPMEndCol();
					set endlin = GetAPMEndLine();
					set removeblunders = GetAPMRemoveBlunders();
					set blunderremovaliteration = GetAPMRemoveBlunderIteration();
					if ($removeblunders)
						enable blunderremovaliteration;
					else
						disable blunderremovaliteration;
					if ($deltacol == 0 && $deltalin == 0 && GetInputImageCount () > 0) {
						set imagewidth = GetInputImageWidth ();
						set imageheight = GetInputImageHeight ();
						set offcol = $imagewidth * 0.05;
						set offlin = $imageheight * 0.05;
						set deltacol = $imagewidth * 0.1;
						set deltalin = $imageheight * 0.1;
						set endcol = $imagewidth * 0.95;
						set endlin = $imageheight * 0.95;
					}
					if ($workflow == "georeference") {
						show referencelayer;		
					}
					else if ($workflow == "edgematch") {
						hide referencelayer;		
					}
				}
			}
